#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_OutgoingShipmentCollection : BaseTest 
	{

		private DataTable _dtShipment;
		private BOL.OutgoingShipmentCollection _tstOSC;
		private Guid _outgoingShipmentGuid;
		private Guid _unitGuid;
		private DataTable _dtColumns;

		[SetUp]
		protected void SetUp() 
		{						
			this.BaseSetUp();

			if (this.RefreshData)
			{
				string sSQL = "SELECT TOP 1 S.ShipmentGuid,S.ShipmentDirection,S.ShipmentDate,S.InvoiceNumber,S.DivisionCode,S.LastUpdateDate, S.LastUpdateUser,S.ShipmentTemperature,S.ShipmentTypeCode,S.RowVersion, L.FacilityName, A.AddressCity,A.StateCode,S.LocalSupplierGuid,L.FdaRegistrationNumber,L.PhoneNumber " +
							  "FROM Shipment S " +
							  "LEFT OUTER JOIN LocalSupplier L ON L.LocalSupplierGuid = S.ShipmentGuid " +
							  "LEFT OUTER JOIN Address A ON L.AddressGuid = A.AddressGuid " +
							  "WHERE S.DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'";

				this._dtColumns = UnitTestUtil.RunSQLGetDataTable(sSQL, false);
				
				Guid lsGuid = DataCreator.GetRecordGuid("SELECT LocalSupplierGuid FROM VamcDivision WHERE DivisionCode = '" + this.TestDivisionCode + "'");

				BOL.BloodUnit tmpUnit = DataCreator.CreateBloodUnit(true);
                DataTable dtInvoiceNumber = UnitTestUtil.RunSQLGetDataTable("SELECT ISNULL(MAX(CAST(col1 AS INT)),0) FROM (select SUBSTRING(InvoiceNumber, LEN('OSC-SetUp-')+1,5) as col1 from shipment where InvoiceNumber like 'OSC-Setup-%') as table1", false);
			    int invoiceNumber = System.Convert.ToInt16(dtInvoiceNumber.Rows[0][0]);
			    invoiceNumber++;    //get the next number
				BOL.OutgoingShipmentCollection tmpOSC = BOL.OutgoingShipmentCollection.CreateOutgoingInvoice("OSC-SetUp-" + invoiceNumber.ToString(), lsGuid, DateTime.Now.AddDays(-1), Common.ShipmentType.ReturnToSupplier, Common.LogonUser.LogonUserName, Common.UpdateFunction.UnitTests);
				tmpOSC.AddUnitToInvoice(BOL.OutgoingShipmentCollection.LineItem.GetLineItem(tmpUnit.BloodUnitGuid));
				tmpOSC.SaveChangesToInvoiceItems(new System.Collections.ArrayList(), Common.UpdateFunction.UnitTests);

				this._dtShipment = UnitTestUtil.RunSQLGetDataTable("SELECT BUS.* FROM BloodUnitShipment BUS JOIN BloodUnit BU ON BU.BloodUnitGuid = BUS.BloodUnitGUID AND BUS.RecordStatusCode = 'A' AND BU.DivisionCode = '" + this.TestDivisionCode + "' WHERE OutgoingShipmentGuid IS NOT NULL AND BU.BloodUnitGuid = '" + tmpUnit.BloodUnitGuid.ToString() + "'", true);

				this._outgoingShipmentGuid = (Guid)this._dtShipment.Rows[0][TABLES.BloodUnitShipment.OutgoingShipmentGuid];

				this.RefreshData = false;

			}

			this._tstOSC = new BOL.OutgoingShipmentCollection(this._outgoingShipmentGuid);
			this._unitGuid = (Guid)this._dtShipment.Rows[0][TABLES.BloodUnitShipment.BloodUnitGuid];
		}

		[Test]
		public void Ctor_Guid_Pass()
		{			
			BOL.OutgoingShipmentCollection tstValue = new BOL.OutgoingShipmentCollection(this._outgoingShipmentGuid);

			Assert.IsNotNull(tstValue);
			Assert.AreEqual(this._outgoingShipmentGuid, tstValue.ShipmentGuid, "ShipmentGuid");
		}
        
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Guid_Fail()
		{
		}

		[Test]
		public void ChangedHandler_Pass()
		{			
			this._tstOSC.ChangedHandler();
			Assert.IsTrue(this._tstOSC.ReadyToSave);
		}
        
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ChangedHandler_Fail()
		{
		}

		[Test]
		public void CreateOutgoingInvoice_Pass()
		{
			string invoiceNumber = "UT" + new Random().Next(111111,999999).ToString();
			Guid lsGuid = (new BOL.Division(this.TestDivisionCode)).LocalSupplierGuid;
			DateTime shipDate = DateTime.Now.AddDays(-1);
			Common.ShipmentType shipType = Common.ShipmentType.ReturnToSupplier;

			BOL.OutgoingShipmentCollection tstValue = BOL.OutgoingShipmentCollection.CreateOutgoingInvoice(invoiceNumber, lsGuid, shipDate, shipType, Common.LogonUser.LogonUserName, Common.UpdateFunction.UnitTests);

			Assert.AreEqual(invoiceNumber, tstValue.InvoiceNumber, "InvoiceNumber");
			Assert.AreEqual(lsGuid, tstValue.LocalSupplierGuid, "LocalSupplierGuid");
			Assert.AreEqual(shipType, tstValue.ShipmentType, "ShipmentType");

		}
        
		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void CreateOutgoingInvoice_Fail()
		{
			DateTime shipDate = DateTime.Now.AddYears(1);
			Common.ShipmentType shipType = Common.ShipmentType.Unknown;

			BOL.OutgoingShipmentCollection retval = BOL.OutgoingShipmentCollection.CreateOutgoingInvoice(null, Guid.Empty, shipDate,	shipType, null, Common.UpdateFunction.UnitTests);
		}

		[Test]
		public void GetOutgoingInvoiceByGuid_Pass()
		{
			BOL.OutgoingShipmentCollection retval = BOL.OutgoingShipmentCollection.GetOutgoingInvoiceByGuid(this._outgoingShipmentGuid);
			
			Assert.AreEqual(this._outgoingShipmentGuid, retval.ShipmentGuid);
		}


		[Test]
		[ExpectedException(typeof(BOL.InvoiceException))]
		public void GetOutgoingInvoiceByGuid_Fail()
		{
			BOL.OutgoingShipmentCollection.GetOutgoingInvoiceByGuid(Guid.NewGuid());
		}

		[Test]
		public void GetInvoiceFromDataRow_Pass()
		{
			Guid shipGuid = (Guid)this._dtColumns.Rows[0][TABLES.Shipment.ShipmentGuid];

			BOL.OutgoingShipmentCollection tstValue = BOL.OutgoingShipmentCollection.GetInvoiceFromDataRow(this._dtColumns.Rows[0]);

			Assert.AreEqual(shipGuid, tstValue.ShipmentGuid);
		}


		[Test]
		[ExpectedException(typeof(BOL.InvoiceException))]
		public void GetInvoiceFromDataRow_Fail()
		{
			BOL.OutgoingShipmentCollection.GetInvoiceFromDataRow(this._dtShipment.Rows[0]);
		}

		[Test]
		public void GetRecentInvoicesForDivisionArray_Pass()
		{
			BOL.OutgoingShipmentCollection[] tstValue = BOL.OutgoingShipmentCollection.GetRecentInvoicesForDivisionArray();

			Assert.IsTrue(tstValue.Length >= 0);
		}


		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetRecentInvoicesForDivisionArray_Fail()
		{
		}

		[Test]
		public void GetRecentInvoicesForDivision_Pass()
		{
			DataTable dtTest = BOL.OutgoingShipmentCollection.GetRecentInvoicesForDivision();

			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetRecentInvoicesForDivision_Fail()
		{
		}

		[Test]
		public void GetShipmentTypeFromChar_Pass()
		{
			char shipmentType = (char)Common.ShipmentType.ReturnToSupplier;

			Common.ShipmentType tstValue = BOL.OutgoingShipmentCollection.GetShipmentTypeFromChar(shipmentType);

			Assert.AreEqual(Common.ShipmentType.ReturnToSupplier, tstValue);
		}


		[Test]
		public void GetShipmentTypeFromChar_Fail()
		{
			char shipmentType = (char)Common.ShipmentType.Unknown;

			Common.ShipmentType tstValue = BOL.OutgoingShipmentCollection.GetShipmentTypeFromChar(shipmentType);

			Assert.AreEqual(Common.ShipmentType.Unknown, tstValue);
		}

		[Test]
		public void GetEligibleUnitsForDivision_Pass()
		{
			DataTable dtTest = BOL.OutgoingShipmentCollection.GetEligibleUnitsForDivision();

			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEligibleUnitsForDivision_Fail()
		{
		}

		[Test]
		public void EligibleUnitStatus_Pass()
		{
			BOL.OutgoingShipmentCollection.ValidStatus tstValue = BOL.OutgoingShipmentCollection.EligibleUnitStatus(Common.UnitStatusCode.Available);

			Assert.AreEqual(BOL.OutgoingShipmentCollection.ValidStatus.Yes, tstValue);
		}

		[Test]
		public void EligibleUnitStatus_Fail()
		{
			BOL.OutgoingShipmentCollection.ValidStatus tstValue = BOL.OutgoingShipmentCollection.EligibleUnitStatus(Common.UnitStatusCode.Unknown);

			Assert.AreEqual(BOL.OutgoingShipmentCollection.ValidStatus.Unknown, tstValue);		
		}

		
		[Test]
		public void GetOutgoingBloodUnitShipment_Pass()
		{
			Guid unitGuid = (Guid)this._dtShipment.Rows[0][TABLES.BloodUnitShipment.BloodUnitGuid];

			DataTable dtTest = BOL.OutgoingShipmentCollection.GetOutgoingBloodUnitShipment(unitGuid);

			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}

		[Test]
		public void GetOutgoingBloodUnitShipment_Fail()
		{
			DataTable dtTest = BOL.OutgoingShipmentCollection.GetOutgoingBloodUnitShipment(Guid.NewGuid());

			Assert.IsTrue(dtTest.Rows.Count == 0);
		}


		[Test]
		public void GetInvoiceText_Pass()
		{
			DataRow dr = BOL.OutgoingShipmentCollection.GetInvoiceText();

			Assert.IsNotNull(dr);
		}


		[Test]
		[Ignore(StandardIgnoreReasons.ParameterlessMethod)]
		public void GetInvoiceText_Fail()
		{
		}

		[Test]
		public void UpdateInvoiceText_Pass()
		{
			this.RefreshData = true;
			DataTable dtDiv = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM VamcDivision WHERE DivisionCode = '" + this.TestDivisionCode + "'", true);

			string userId = Common.LogonUser.LogonUserName;
			string tstText = "UnitTesting on " + DateTime.Now.ToString();
			byte[] rowVersion = (byte[])dtDiv.Rows[0][TABLES.VamcDivision.RowVersion];

			bool tstValue = BOL.OutgoingShipmentCollection.UpdateInvoiceText(userId, tstText, Common.UpdateFunction.UnitTests, rowVersion);
			
			Assert.IsTrue(tstValue);
		}


		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void UpdateInvoiceText_Fail()
		{
			DataTable dtDiv = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM VamcDivision WHERE DivisionCode = '" + this.TestDivisionCode + "'", true);

			string userId = "Yummy";
			string tstText = "UnitTesting on " + DateTime.Now.ToString();
			byte[] rowVersion = new byte[8];

			bool tstValue = BOL.OutgoingShipmentCollection.UpdateInvoiceText(userId, tstText, Common.UpdateFunction.UnitTests, rowVersion);
			
			Assert.IsTrue(tstValue);
		}

		
		[Test]
		public void GetShipmentInvoiceCount_Pass()
		{
			DataTable dtShipment = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Shipment WHERE RecordStatusCode = 'A' AND ShipmentDirection = 0 AND DivisionCode = '" + this.TestDivisionCode + "'");
			
			string invoiceNumber = dtShipment.Rows[0][TABLES.Shipment.InvoiceNumber].ToString().Trim();
			Guid lsGuid = (Guid)dtShipment.Rows[0][TABLES.Shipment.LocalSupplierGuid];

			DataTable dtCount = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM Shipment WHERE InvoiceNumber = '" + invoiceNumber + "' AND ShipmentDirection = 0 AND LocalSupplierGuid = '" + lsGuid.ToString() + "'");

			int retValue = BOL.OutgoingShipmentCollection.GetShipmentInvoiceCount(lsGuid, invoiceNumber);

			Assert.AreEqual(dtCount.Rows.Count, retValue, "ReturnValue");
		}
		
		[Test]
		public void GetShipmentInvoiceCount_Fail()
		{
			int retValue = BOL.OutgoingShipmentCollection.GetShipmentInvoiceCount(Guid.NewGuid(), "PIZZA");

			Assert.AreEqual(0, retValue, "ReturnValue");
		}

		[Test]
		public void SaveChangesToInvoiceItems_Pass()
		{
			System.Collections.ArrayList alErrors = new System.Collections.ArrayList();
			
			string sSQL = "SELECT TOP 1 BloodUnit.BloodUnitGuid " +
				"FROM BloodUnit " +
				"WHERE BloodUnit.BloodUnitGuid NOT IN (SELECT BloodUnitGuid FROM BloodUnitShipment WHERE OutgoingShipmentGuid IS NOT NULL)" +
				"AND BloodUnit.RecordStatusCode='A' AND BloodUnit.DivisionCode = '" + this.TestDivisionCode + "'";

			DataTable dtGuid = UnitTestUtil.RunSQLGetDataTable(sSQL, false);

			BOL.OutgoingShipmentCollection.LineItem li=BOL.OutgoingShipmentCollection.LineItem.GetLineItem((Guid)dtGuid.Rows[0][0]);
			
			this._tstOSC.AddUnitToInvoice(li);

			BOL.OutgoingShipmentCollection.LineItem tstItem = BOL.OutgoingShipmentCollection.LineItem.GetLineItemForUpdate(this._unitGuid);

			this._tstOSC.RemoveUnitFromInvoice(tstItem);

			this._tstOSC.SaveChangesToInvoiceItems(alErrors, Common.UpdateFunction.UnitTests);

			Assert.AreEqual(0, alErrors.Count, "ErrorArray.Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SaveChangesToInvoiceItems_Fail()
		{
		}

		[Test]
		public void RemoveAllUnitsFromThisInvoice_Pass()
		{
			this.RefreshData = true;

			this._tstOSC.RemoveAllUnitsFromThisInvoice(Common.UpdateFunction.UnitTests);

			Assert.IsTrue(true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RemoveAllUnitsFromThisInvoice_Fail()
		{
		}

		[Test]
		public void RemoveUnitFromInvoice_Pass()
		{
			this.RefreshData = true;

			BOL.OutgoingShipmentCollection.LineItem tstItem = BOL.OutgoingShipmentCollection.LineItem.GetLineItemForUpdate(this._unitGuid);

			this._tstOSC.RemoveUnitFromInvoice(tstItem);
			
			Assert.IsTrue(true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RemoveUnitFromInvoice_Fail()
		{
		}

		[Test]
		public void AddUnitToInvoice_Pass()
		{
			BOL.OutgoingShipmentCollection.LineItem tmpItem = BOL.OutgoingShipmentCollection.LineItem.GetLineItem(this._unitGuid);

			tmpItem.BloodUnitGuid = Guid.NewGuid();

			this._tstOSC.AddUnitToInvoice(tmpItem);

			Assert.IsTrue(true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void AddUnitToInvoice_Fail()
		{
		}

		[Test]
		public void ModifyReturnCredit_Pass()
		{
			decimal tstValue = new decimal(123.45F);

			BOL.OutgoingShipmentCollection.LineItem tmpItem = BOL.OutgoingShipmentCollection.LineItem.GetLineItem(this._unitGuid);

			this._tstOSC.ModifyReturnCredit(tmpItem, tstValue);

			Assert.AreEqual(tstValue, tmpItem.ReturnCreditAmount);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ModifyReturnCredit_Fail()
		{
		}

		[Test]
		public void ConfirmShipment_Pass()
		{
			this.RefreshData = true;

			DateTime tstDate = DateTime.Now;

			this._tstOSC.Confirmed=false;
			this._tstOSC.ReadyToConfirm=true;

			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.UnitLogout);
			bool tstValue = this._tstOSC.ConfirmShipment(tstDate, Common.UpdateFunction.UnitTests, Common.WorkloadProcessID.UnitLogout);

			Assert.IsTrue(tstValue);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void ConfirmShipment_Fail()
		{
			this._tstOSC.ConfirmShipment(DateTime.MinValue, Common.UpdateFunction.UnitTests, Common.WorkloadProcessID.Unknown);
		}

		[Test]
		public void VerifyMinColumnsInDataTable_Pass()
		{
			string columnList = BOL.OutgoingShipmentCollection.INVOICECOLUMNS;

			bool retval = _tstOSC.VerifyMinColumnsInDataTable(columnList, this._dtColumns);

			Assert.IsTrue(retval);
		}


		[Test]
		public void VerifyMinColumnsInDataTable_Fail()
		{
			string columnList = "1,2,3,4,5";

			bool retval = _tstOSC.VerifyMinColumnsInDataTable(columnList, this._dtShipment);
			
			Assert.IsTrue(retval == false);
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataRow dr = this._tstOSC.LoadDataRowFromThis(this._dtColumns.NewRow());

			Assert.AreEqual(this._dtColumns.Columns.Count, dr.Table.Columns.Count);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}

		[Test]
		public void CancelThisInvoice_Pass()
		{
			System.Collections.Hashtable retval;
            
			retval =_tstOSC.CancelThisInvoice(Common.LogonUser.LogonUserName);
			Assert.IsNotNull(retval);
		}


		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void CancelThisInvoice_Fail()
		{
			System.Collections.Hashtable retval;
            
			retval =_tstOSC.CancelThisInvoice(null);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GetXmlReportDataSet_Pass()
		{
			//File Access - voids UnitTest
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetXmlReportDataSet_Fail()
		{
		}

		[Test]
		public void GetReportDataSet_Pass()
		{
			DataSet dsTest = this._tstOSC.GetReportDataSet();

			Assert.AreEqual(2, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(14, dsTest.Tables[0].Columns.Count, "Tables[0].Columns.Count");
			Assert.AreEqual(7, dsTest.Tables[1].Columns.Count, "Tables[1].Columns.Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetReportDataSet_Fail()
		{

		}

		[Test]
		public void InErrorState_Pass()
		{

			bool tstValue = (!this._tstOSC.InErrorState);

			this._tstOSC.InErrorState = tstValue;

			Assert.AreEqual(tstValue, this._tstOSC.InErrorState);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InErrorState_Fail()
		{
		}

		[Test]
		public void Count_Pass()
		{
			int tstValue = this._tstOSC.Count;
			
			Assert.AreEqual(tstValue, this._tstOSC.Count);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void Count_Fail()
		{
		}

		[Test]
		public void SyncRoot_Pass()
		{
			object tstValue = this._tstOSC.SyncRoot;
			
			Assert.AreEqual(tstValue, this._tstOSC.SyncRoot);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void SyncRoot_Fail()
		{
		}

		[Test]
		public void IsSynchronized_Pass()
		{
			bool tstValue = this._tstOSC.IsSynchronized;
			
			Assert.AreEqual(tstValue, this._tstOSC.IsSynchronized);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void IsSynchronized_Fail()
		{
		}

		[Test]
		public void GetEnumerator_Pass()
		{
			System.Collections.IEnumerator tstValue = this._tstOSC.GetEnumerator();
			
			Assert.IsNotNull(tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void GetEnumerator_Fail()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void CopyTo_Pass()
		{
			//CopyTo is dead code, it is only called from a private method, called ClearInvoice, which also is never called
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void CopyTo_Fail()
		{
			this._tstOSC.CopyTo("1,2,3,4,5".ToCharArray(), 20);
		}

		[Test]
		public void This_Pass()
		{
			Guid lsGuid = DataCreator.GetRecordGuid("SELECT LocalSupplierGuid FROM VamcDivision WHERE DivisionCode = '" + this.TestDivisionCode + "'");
			BOL.BloodUnit tmpUnit = DataCreator.CreateBloodUnit(true);
			BOL.OutgoingShipmentCollection tmpOSC = BOL.OutgoingShipmentCollection.CreateOutgoingInvoice("OSC-SetUp-" + new Random().Next(500).ToString(), lsGuid, DateTime.Now.AddDays(-1), Common.ShipmentType.ReturnToSupplier, Common.LogonUser.LogonUserName, Common.UpdateFunction.UnitTests);
			tmpOSC.AddUnitToInvoice(BOL.OutgoingShipmentCollection.LineItem.GetLineItem(tmpUnit.BloodUnitGuid));
			tmpOSC.SaveChangesToInvoiceItems(new System.Collections.ArrayList(), Common.UpdateFunction.UnitTests);
			DataTable dtShipment = UnitTestUtil.RunSQLGetDataTable("SELECT BUS.* FROM BloodUnitShipment BUS JOIN BloodUnit BU ON BU.BloodUnitGuid = BUS.BloodUnitGUID AND BUS.RecordStatusCode = 'A' AND BU.DivisionCode = '" + this.TestDivisionCode + "' WHERE OutgoingShipmentGuid IS NOT NULL AND BU.BloodUnitGuid = '" + tmpUnit.BloodUnitGuid.ToString() + "'", true);
			Guid bloodUnitGuid = (Guid)dtShipment.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
			Guid shipmentGuid = (Guid)dtShipment.Rows[0][TABLES.BloodUnitShipment.OutgoingShipmentGuid];
			//
			BOL.OutgoingShipmentCollection osc = new OutgoingShipmentCollection(shipmentGuid);
			//
			bool itemFound = false;
			//
			foreach(OutgoingShipmentCollection.LineItem li in osc.Values) 
			{
				if(li.BloodUnitGuid == bloodUnitGuid)
				{
					itemFound = true;
					break;
				}
			}
			//
			Assert.IsTrue(itemFound);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void This_Fail()
		{
		}

		[Test]
		public void Values_Pass()
		{
			System.Collections.ICollection tstValue = this._tstOSC.Values;

			Assert.IsNotNull(tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void Values_Fail()
		{
		}

		[Test]
		public void IsDirty_Pass()
		{
			Assert.AreEqual(this._tstOSC.IsDirty, true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsDirty_Fail()
		{
		}

		[Test]
		public void ShipmentGuid_Pass()
		{
			Guid tstGuid = _tstOSC.ShipmentGuid;

			Assert.AreEqual(tstGuid , this._tstOSC.ShipmentGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ShipmentGuid_Fail()
		{
		}

		[Test]
		public void ShipmentDirection_Pass()
		{
			bool tstValue = _tstOSC.ShipmentDirection;

			Assert.AreEqual(tstValue , this._tstOSC.ShipmentDirection);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ShipmentDirection_Fail()
		{
		}

		[Test]
		public void ShipmentDate_Pass()
		{
			DateTime tstValue = DateTime.Now;

			this._tstOSC.ShipmentDate = tstValue;

			Assert.AreEqual(tstValue, _tstOSC.ShipmentDate);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void ShipmentDate_Fail()
		{
			this._tstOSC.ShipmentDate = DateTime.MaxValue;
		}

		[Test]
		public void InvoiceNumber_Pass()
		{
			string tstValue = _tstOSC.InvoiceNumber;
			
			Assert.AreEqual(tstValue, _tstOSC.InvoiceNumber);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void InvoiceNumber_Fail()
		{
		}

		[Test]
		public void ShipmentTemperature_Pass()
		{
			short tstValue = _tstOSC.ShipmentTemperature;
			
			Assert.AreEqual(tstValue, _tstOSC.ShipmentTemperature);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ShipmentTemperature_Fail()
		{
		}

		[Test]
		public void ShipmentType_Pass()
		{
			Common.ShipmentType tstValue = _tstOSC.ShipmentType;
			
			Assert.AreEqual(tstValue, _tstOSC.ShipmentType);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ShipmentType_Fail()
		{
		}


		[Test]
		public void LocalSupplierGuid_Pass()
		{
			Guid tstGuid = _tstOSC.LocalSupplierGuid;
			
			Assert.AreEqual(tstGuid, _tstOSC.LocalSupplierGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void LocalSupplierGuid_Fail()
		{
		}

		[Test]
		public void LocalSupplier_Pass()
		{
			BOL.LocalSupplier tstValue = _tstOSC.LocalSupplier;
			
			Assert.AreEqual(tstValue, _tstOSC.LocalSupplier);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void LocalSupplier_Fail()
		{
		}

		[Test]
		public void FacilityName_Pass()
		{
			string tstValue = _tstOSC.FacilityName;
			
			Assert.AreEqual(tstValue, _tstOSC.FacilityName);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void FacilityName_Fail()
		{
		}

		[Test]
		public void ReadyToSave_Pass()
		{
			bool tstValue = (!this._tstOSC.ReadyToSave);

			this._tstOSC.ReadyToSave = tstValue;

			Assert.AreEqual(tstValue, _tstOSC.ReadyToSave);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReadyToSave_Fail()
		{
		}


		[Test]
		public void ReadyToPrint_Pass()
		{
			bool tstValue = (!_tstOSC.ReadyToPrint);

			this._tstOSC.ReadyToPrint = tstValue;

			Assert.AreEqual(tstValue, _tstOSC.ReadyToPrint);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReadyToPrint_Fail()
		{
		}

		[Test]
		public void ReadyToConfirm_Pass()
		{
			bool tstValue = (_tstOSC.ReadyToConfirm);

			Assert.AreEqual(tstValue, _tstOSC.ReadyToConfirm);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReadyToConfirm_Fail()
		{
		}

		[Test]
		public void RecordStatusCode_Pass()
		{
			this._tstOSC.RecordStatusCode = Common.RecordStatusCode.Historical;

			Assert.AreEqual(Common.RecordStatusCode.Historical, this._tstOSC.RecordStatusCode);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RecordStatusCode_Fail()
		{
		}

		[Test]
		public void Canceled_Pass()
		{
			bool tstValue = (!this._tstOSC.Canceled);

			_tstOSC.Canceled = tstValue;
			
			Assert.AreEqual(tstValue, _tstOSC.Canceled);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Canceled_Fail()
		{
		}


		[Test]
		public void Saved_Pass()
		{
			bool tstValue = (!_tstOSC.Saved);

			this._tstOSC.Saved = tstValue;

			Assert.AreEqual(tstValue, _tstOSC.Saved);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Saved_Fail()
		{
		}


		[Test]
		public void Confirmed_Pass()
		{
			bool tstValue = (!_tstOSC.Confirmed);

			this._tstOSC.Confirmed = tstValue;

			Assert.AreEqual(tstValue, _tstOSC.Confirmed);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Confirmed_Fail()
		{
		}

		[Test]
		public void LineItem_GetLineItemForUpdate_Pass()
		{
			BOL.OutgoingShipmentCollection.LineItem tstValue = BOL.OutgoingShipmentCollection.LineItem.GetLineItemForUpdate(this._unitGuid);
			
			Assert.IsNotNull( tstValue );
			Assert.AreEqual(this._unitGuid, tstValue.BloodUnitGuid, "BloodUnitGuid");
		}

		
		[Test]
		//TODO		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LineItem_GetLineItemForUpdate_Fail()
		{
			Guid newGuid = Guid.NewGuid();
			BOL.OutgoingShipmentCollection.LineItem tstValue = BOL.OutgoingShipmentCollection.LineItem.GetLineItemForUpdate(newGuid);
			
			Assert.IsNotNull( tstValue );
			Assert.AreEqual(newGuid, tstValue.BloodUnitGuid, "BloodUnitGuid");
		}

		[Test]
		public void LineItem_GetLineItem_Pass()
		{
			BOL.OutgoingShipmentCollection.LineItem tstValue = BOL.OutgoingShipmentCollection.LineItem.GetLineItem(this._unitGuid);
			
			Assert.IsNotNull( tstValue );
			Assert.AreEqual(this._unitGuid, tstValue.BloodUnitGuid, "BloodUnitGuid");
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LineItem_GetLineItem_Fail()
		{
		}


		[Test]
		public void LineItem_ValidForShipment_Pass()
		{
			BOL.OutgoingShipmentCollection.LineItem tmpItem = BOL.OutgoingShipmentCollection.LineItem.GetLineItem( this._unitGuid );

			bool tstValue = (tmpItem.ValidForShipment);

			Assert.AreEqual(tstValue, tmpItem.ValidForShipment);
		}

		[Test]
		public void LineItem_ValidForShipment_Fail()
		{
			DataRow finalUnit = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 BloodUnitGuid FROM dbo.BloodUnitStatusCodeCurrent WHERE UnitStatusCode IN ('D','M','T','X')");
			BOL.OutgoingShipmentCollection.LineItem tmpItem = BOL.OutgoingShipmentCollection.LineItem.GetLineItem( (Guid)finalUnit[TABLES.BloodUnit.BloodUnitGuid] );
			Assert.AreEqual(false, tmpItem.ValidForShipment);
		}

		[Test]
		public void LineItem_OutgoingShipmentGuid_Pass()
		{
			BOL.OutgoingShipmentCollection.LineItem tmpItem = BOL.OutgoingShipmentCollection.LineItem.GetLineItem(this._unitGuid);
			
			Guid tstGuid = tmpItem.OutgoingShipmentGuid;

			Assert.AreEqual(tstGuid, tmpItem.OutgoingShipmentGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LineItem_OutgoingShipmentGuid_Fail()
		{
		}

		[Test]
		public void LineItem_AboRh_Pass()
		{
			BOL.OutgoingShipmentCollection.LineItem tmpItem = BOL.OutgoingShipmentCollection.LineItem.GetLineItem(this._unitGuid);
			
			string tstValue = tmpItem.AboRh;

			Assert.AreEqual(tstValue, tmpItem.AboRh);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void LineItem_AboRh_Fail()
		{
		}

		[Test]
		public void LineItem_IsBiohazardous_Pass()
		{
			BOL.OutgoingShipmentCollection.LineItem tmpItem = BOL.OutgoingShipmentCollection.LineItem.GetLineItem(this._unitGuid);
			
			bool tstValue = tmpItem.IsBiohazardous;

			Assert.AreEqual(tstValue, tmpItem.IsBiohazardous);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void LineItem_IsBiohazardous_Fail()
		{
		}

		[Test]
		public void LineItem_ReturnCreditAmount_Pass()
		{
			BOL.OutgoingShipmentCollection.LineItem tmpItem = BOL.OutgoingShipmentCollection.LineItem.GetLineItem(this._unitGuid);
			
			decimal tstValue = tmpItem.ReturnCreditAmount;

			Assert.AreEqual(tstValue, tmpItem.ReturnCreditAmount);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LineItem_ReturnCreditAmount_Fail()
		{
		}
		
		[Test]
		public void LineItem_PatientName_Pass()
		{
			BOL.OutgoingShipmentCollection.LineItem tmpItem = BOL.OutgoingShipmentCollection.LineItem.GetLineItem(this._unitGuid);
			
			string tstValue = tmpItem.PatientName;

			Assert.AreEqual(tstValue, tmpItem.PatientName);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void LineItem_PatientName_Fail()
		{
		}

		[Test]
		public void LineItem_IsQuarantined_Pass()
		{
			BOL.OutgoingShipmentCollection.LineItem tmpItem = BOL.OutgoingShipmentCollection.LineItem.GetLineItem(this._unitGuid);
			
			bool tstValue = tmpItem.IsQuarantined;

			Assert.AreEqual(tstValue, tmpItem.IsQuarantined);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void LineItem_IsQuarantined_Fail()
		{
		}

		[Test]
		public void LineItem_EligibleUnitStatus_Pass()
		{
			BOL.OutgoingShipmentCollection.LineItem tmpItem = BOL.OutgoingShipmentCollection.LineItem.GetLineItem(this._unitGuid);
			
			BOL.OutgoingShipmentCollection.ValidStatus tstValue = tmpItem.EligibleUnitStatus();

			Assert.AreEqual(tstValue, tmpItem.EligibleUnitStatus());
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LineItem_EligibleUnitStatus_Fail()
		{
		}

		[Test]
		public void IsBloodUnitOnPendingOutgoingShipment_Pass()
		{
			Guid unitGuid = Guid.NewGuid();
			DataCreator.CreateBloodUnit(unitGuid, Guid.NewGuid(), Guid.Empty, DataCreator.GetRandomBloodProduct(true, Common.ComponentClass.ConversionClass).BloodProductGuid, true);
			Guid lsGuid = DataCreator.GetRecordGuid("SELECT LocalSupplierGuid FROM VamcDivision WHERE DivisionCode = '" + this.TestDivisionCode + "'");
			BOL.OutgoingShipmentCollection tmpOS = BOL.OutgoingShipmentCollection.CreateOutgoingInvoice("Test7547a-" + new Random().Next(500).ToString(), lsGuid, DateTime.Now.AddDays(-1), Common.ShipmentType.ReturnToSupplier, Common.LogonUser.LogonUserName, Common.UpdateFunction.UnitTests);
			tmpOS.AddUnitToInvoice(BOL.OutgoingShipmentCollection.LineItem.GetLineItem(unitGuid));
			tmpOS.SaveChangesToInvoiceItems(new System.Collections.ArrayList(), Common.UpdateFunction.UnitTests);

			bool isOnPendingShipment = BOL.OutgoingShipmentCollection.IsBloodUnitOnPendingOutgoingShipment( unitGuid );
			//
			Assert.AreEqual(true, isOnPendingShipment, "Pending Shipment" );
			
			StringBuilder query = new StringBuilder();
			query.Append( "SELECT TOP 1 BUS.BloodUnitGuid FROM dbo.BloodUnitShipment BUS " );
			query.Append( "JOIN dbo.Shipment S ON S.ShipmentGuid = BUS.OutgoingShipmentGuid " );
			query.Append( "WHERE S.ShipmentDate IS NOT NULL AND BUS.RecordStatusCode = 'A' " );
			query.Append( "AND BUS.OutgoingShipmentGuid IS NOT NULL AND S.DivisionCode = '" );
			query.Append( UnitTestConfig.TestDivisionCode );
			query.Append( "'" );
			//
			DataTable dt2 = UnitTestUtil.RunSQLGetDataTable( query.ToString(), false );
			if (dt2.Rows.Count == 0)
			{
				unitGuid = Guid.NewGuid();
				DataCreator.CreateBloodUnit(unitGuid, Guid.NewGuid(), Guid.Empty, DataCreator.GetRandomBloodProduct(true, Common.ComponentClass.ConversionClass).BloodProductGuid, true);
				lsGuid = DataCreator.GetRecordGuid("SELECT LocalSupplierGuid FROM VamcDivision WHERE DivisionCode = '" + this.TestDivisionCode + "'");
				tmpOS = BOL.OutgoingShipmentCollection.CreateOutgoingInvoice("Test7547a-" + new Random().Next(500).ToString(), lsGuid, DateTime.Now.AddDays(-1), Common.ShipmentType.ReturnToSupplier, Common.LogonUser.LogonUserName, Common.UpdateFunction.UnitTests);
				tmpOS.AddUnitToInvoice(BOL.OutgoingShipmentCollection.LineItem.GetLineItem(unitGuid));
				tmpOS.SaveChangesToInvoiceItems(new System.Collections.ArrayList(), Common.UpdateFunction.UnitTests);
				DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.UnitLogout);
				tmpOS.ConfirmShipment(System.DateTime.Now, Common.UpdateFunction.UnitTests, Common.WorkloadProcessID.UnitLogout);

				dt2 = UnitTestUtil.RunSQLGetDataTable( query.ToString(), true );
			}
			//
			unitGuid = (Guid)dt2.Rows[0][TABLES.BloodUnitShipment.BloodUnitGuid];
			//
			isOnPendingShipment = BOL.OutgoingShipmentCollection.IsBloodUnitOnPendingOutgoingShipment( unitGuid );
			//
			Assert.AreEqual(false, isOnPendingShipment, "Confirmed Shipment" );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsBloodUnitOnPendingOutgoingShipment_Fail()
		{
		}



		#region ReadyToSaveChangedEventArg

		[Test]
		public void ReadyToSaveChangedEventArgs_Ctor_Pass()
		{
			BOL.OutgoingShipmentCollection.ReadyToSaveChangedEventArgs tstValue = new BOL.OutgoingShipmentCollection.ReadyToSaveChangedEventArgs(true);

			Assert.IsNotNull(tstValue);

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReadyToSaveChangedEventArgs_Ctor_Fail()
		{
		}

		[Test]
		public void ReadyToSaveChangedEventArgs_ReadToSave_Pass()
		{
			BOL.OutgoingShipmentCollection.ReadyToSaveChangedEventArgs tstValue = new BOL.OutgoingShipmentCollection.ReadyToSaveChangedEventArgs(true);

			Assert.AreEqual(true, tstValue.ReadyToSave);

		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ReadyToSaveChangedEventArgs_ReadToSave_Fail()
		{
		}


		#endregion


		
		#region ReadyToConfirmChangedEventArg

		[Test]
		public void ReadyToConfirmChangedEventArgs_Ctor_Pass()
		{
			BOL.OutgoingShipmentCollection.ReadyToConfirmChangedEventArgs tstValue = new BOL.OutgoingShipmentCollection.ReadyToConfirmChangedEventArgs(true);

			Assert.IsNotNull(tstValue);

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReadyToConfirmChangedEventArgs_Ctor_Fail()
		{
		}

		[Test]
		public void ReadyToConfirmChangedEventArgs_ReadToConfirm_Pass()
		{
			BOL.OutgoingShipmentCollection.ReadyToConfirmChangedEventArgs tstValue = new BOL.OutgoingShipmentCollection.ReadyToConfirmChangedEventArgs(true);

			Assert.AreEqual(true, tstValue.ReadyToConfirm);

		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ReadyToConfirmChangedEventArgs_ReadToConfirm_Fail()
		{
		}


		#endregion


				
		#region ReadyToPrintChangedEventArg

		[Test]
		public void ReadyToPrintChangedEventArgs_Ctor_Pass()
		{
			BOL.OutgoingShipmentCollection.ReadyToPrintChangedEventArgs tstValue = new BOL.OutgoingShipmentCollection.ReadyToPrintChangedEventArgs(true);

			Assert.IsNotNull(tstValue);

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReadyToPrintChangedEventArgs_Ctor_Fail()
		{
		}

		[Test]
		public void ReadyToPrintChangedEventArgs_ReadToPrint_Pass()
		{
			BOL.OutgoingShipmentCollection.ReadyToPrintChangedEventArgs tstValue = new BOL.OutgoingShipmentCollection.ReadyToPrintChangedEventArgs(true);

			Assert.AreEqual(true, tstValue.ReadyToPrint);

		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ReadyToPrintChangedEventArgs_ReadToPrint_Fail()
		{
		}


		#endregion


		#region CanceledChangedEventArg

		[Test]
		public void CanceledChangedEventArgs_Ctor_Pass()
		{
			BOL.OutgoingShipmentCollection.CanceledChangedEventArgs tstValue = new BOL.OutgoingShipmentCollection.CanceledChangedEventArgs(true);

			Assert.IsNotNull(tstValue);

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void CanceledChangedEventArgs_Ctor_Fail()
		{
		}

		[Test]
		public void CanceledChangedEventArgs_Canceled_Pass()
		{
			BOL.OutgoingShipmentCollection.CanceledChangedEventArgs tstValue = new BOL.OutgoingShipmentCollection.CanceledChangedEventArgs(true);

			Assert.AreEqual(true, tstValue.Canceled);

		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void CanceledChangedEventArgs_Canceled_Fail()
		{
		}


		#endregion


		#region SavedChangedEventArg

		[Test]
		public void SavedChangedEventArgs_Ctor_Pass()
		{
			BOL.OutgoingShipmentCollection.SavedChangedEventArgs tstValue = new BOL.OutgoingShipmentCollection.SavedChangedEventArgs(true);

			Assert.IsNotNull(tstValue);

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SavedChangedEventArgs_Ctor_Fail()
		{
		}

		[Test]
		public void SavedChangedEventArgs_Saved_Pass()
		{
			BOL.OutgoingShipmentCollection.SavedChangedEventArgs tstValue = new BOL.OutgoingShipmentCollection.SavedChangedEventArgs(true);

			Assert.AreEqual(true, tstValue.Saved);

		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void SavedChangedEventArgs_Saved_Fail()
		{
		}


		#endregion


		#region ConfirmedChangedEventArg

		[Test]
		public void ConfirmedChangedEventArgs_Ctor_Pass()
		{
			BOL.OutgoingShipmentCollection.ConfirmedChangedEventArgs tstValue = new BOL.OutgoingShipmentCollection.ConfirmedChangedEventArgs(true);

			Assert.IsNotNull(tstValue);

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ConfirmedChangedEventArgs_Ctor_Fail()
		{
		}

		[Test]
		public void ConfirmedChangedEventArgs_Confirmed_Pass()
		{
			BOL.OutgoingShipmentCollection.ConfirmedChangedEventArgs tstValue = new BOL.OutgoingShipmentCollection.ConfirmedChangedEventArgs(true);

			Assert.AreEqual(true, tstValue.Confirmed);

		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ConfirmedChangedEventArgs_Confirmed_Fail()
		{
		}


		#endregion
 

	}
}
#endif

